function [CVine,theta]=CVineStruct(data,ind)
% creates the Canonical vine decomposition of the initial data based on a
% given permutation of the data columns, given in ind. 
% INPUTS:
% data: a matrix with uniform U(0,1) columns or a positive integer
% ind: a permutation of the column numbers (optional). If you do not
% provide ind=[1 2 3 ... N]
% Obviously the column number of the matrix data and the column number of
% the row vector ind, should be equal!!
% OUTPUT:
% CVine: A structure with size 1x(N-1) --> N=columns of data
% Each of the CVine pages represents a CVine tree,that contains the
% following fields:
% 1) Variables: A cell array that contains the column indexes of the data,
% for the specific tree.
% 2) CondVariables: A cell array that contains the column indexes of the 
% conditioning data set,for the specific tree.
% 3) copparam: the parameter of the copula (correlation or partial
% correlation)
% 4) data and conddata: contain the data columns with indices described in
% 1) and 2)
% EXAMPLE: in a canonical vine with five variables, in the second tree
% there are the following variables: 23|1, 24|1 and 25|1. 
% In the CVine(1,2) you will find:
% variables: [2 3] [2 4] [2 5]
% condvariables: [1] [1] [1]
% data: [data(:,2) data(:,3)], [data(:,2) data(:,4)], [data(:,2) data(:,5)]
% conddata: [data(:,1)], [data(:,1)], [data(:,1)]
% copparam: partial correlation of data, given conddata
if isscalar(data)==1
    data=copularnd('Gaussian',gallery('randcorr',data),1000);
    N=size(data,2);
else
N=size(data,2);
end
if nargin==1
ind=linspace(1,N,N); % default indexes are: 1,2,3...,N
end
if size(data,2)~=size(ind,2)
    error('ind and data should have the same columns');
end
CVine=struct;
theta=cell(N-1,N-1);
for i=1:N-1
    CVine(1).variables{i}=[ind(1),ind(i+1)];
    CVine(1).data{i}=[data(:,ind(1)),data(:,ind(1+i))];
    XX=[data(:,ind(1)),data(:,ind(1+i))];
    CVine(1).copparam{i}=corr(XX);
    CVine(1).corr{i}=CVine(1).copparam{i}(1,2);
    theta{1,i}=CVine(1).copparam{i}(1,2);
end
for j=2:N-1 % the trees
    for i=1:N-j
    CVine(j).variables{i}=[ind(j),ind(j+i)];
    CVine(j).condvariables{i}=ind(1:j-1);
    CVine(j).data{i}=[data(:,ind(j)),data(:,ind(j+i))];
    CVine(j).conddata{i}=data(:,ind(1:j-1));
    XX=[data(:,ind(j)),data(:,ind(j+i))]; YY=data(:,ind(1:j-1));
    CVine(j).copparam{i}=partialcorr(XX,YY);
    CVine(j).parcorr{i}=CVine(j).copparam{i}(1,2);
    theta{j,i}=CVine(j).copparam{i}(1,2);
    end
end